function load_strings()
    str = {}
    file_load_strings("str", "strings.txt")
    if file_exists("strings_local.txt") then
        file_load_strings("str", "strings_local.txt")
    end
end


function load_game_scripts()
    log("Started loading game scripts")

    file_load_lua("scripts/config.lua")
    file_load_lua("build_config.lua")

    file_load_lua("scripts/objects/card.lua")
    file_load_lua("scripts/objects/spot.lua")
    file_load_lua("scripts/views/splash_screen.lua")
    file_load_lua("scripts/views/main_menu.lua")
    file_load_lua("scripts/views/congratulations.lua")
    file_load_lua("scripts/views/level.lua")
    file_load_lua("scripts/views/level_double_klondike.lua")
    file_load_lua("scripts/views/save_score.lua")
    file_load_lua("scripts/views/menu_options.lua")
    file_load_lua("scripts/views/menu_credits.lua")
    file_load_lua("scripts/views/menu_support.lua")
    file_load_lua("scripts/views/menu_scores.lua")
    file_load_lua("scripts/views/story_selector.lua")
    file_load_lua("scripts/views/story.lua")
    file_load_lua("scripts/views/ingame_options.lua")
    file_load_lua("scripts/views/paused.lua")
    file_load_lua("scripts/views/help.lua")
    file_load_lua("scripts/views/game_selector.lua")

    file_load_lua("scripts/game_settings.lua")
    file_load_lua("scripts/top_scores.lua")
    


    if file_exists("local.lua") then
        file_load_lua("local.lua")
    end
    log("Done loading game scripts")
end

----------------------------------------------------------------------

function boot()
    load_strings()
    file_load_lua("framework/framework.lua")
    fw = Framework:new()
    load_game_scripts()
    load_game_settings()
    gfx_full_screen(game_settings.full_screen)

    fw:boot_end()
end


function init()
    local extra = file_load_lua_table("extra/config.lua")
    product_version = extra.product_version
    log("Game version: "..product_version.." (build: "..kiss.app_build..")")

    gfx_load_font("fonts/*.xml")
    top_scores = TopScores:new()
    snd_sound_volume(game_settings.sound_volume * 100)
    snd_music_volume(game_settings.music_volume * 100)
    snd_load("sounds.txt")
    paused_bitmap = gfx_load_bitmap("gfx/bkg_paused")

    fw:init_end()
end


function destroy()
    gfx_release_bitmap(paused_bitmap)
    fw:destroy()
end


function update(dt)
    fw:update(dt)
end


function render()
    fw:render()
    if not app_active() then
        --gfx_render_box(0, 0, 800, 600, 0.8, 0, "000000")
        gfx_render_sprite(paused_bitmap, "main", 0, 0, 1, 0, 1.6, 1.6)
        gfx_render_text("title46", 400, 300, str.paused, "center vcenter")
    end
end


function start_game()
    if dev_mode then
        fw:change_view(MainMenu)
        --starting_view = LevelDoubleKlondike
    else
        fw:change_view(SplashScreen)
    end
end
